<?php

include 'fns/sql/Medoo.php';
use Medoo\Medoo;

class DB {
    private static $instances = [];
    private static $lastCheck = [];

    public static function connect($workerId = null) {
        $cid = \Swoole\Coroutine::getCid();
        $workerId = $workerId ?? ($GLOBALS['swoole_worker_id'] ?? 0);
        $key = $workerId . '-' . $cid;
        $now = time();

        if (!isset(self::$instances[$key])) {
            self::$instances[$key] = new Medoo(Registry::load('config')->database);
            self::$lastCheck[$key] = $now;
        } elseif (($now - (self::$lastCheck[$key] ?? 0)) > 60) {
            try {
                self::$instances[$key]->query('SELECT 1');
            } catch (Exception $e) {
                // Reconnect if the ping fails
                self::$instances[$key] = new Medoo(Registry::load('config')->database);
            }
            self::$lastCheck[$key] = $now;
        }

        return self::$instances[$key];
    }

    public static function reset($workerId = null) {
        $cid = \Swoole\Coroutine::getCid();
        $workerId = $workerId ?? ($GLOBALS['swoole_worker_id'] ?? 0);
        $key = $workerId . '-' . $cid;

        if (isset(self::$instances[$key])) {
            unset(self::$instances[$key]);
            unset(self::$lastCheck[$key]);
        }
    }

    public static function closeConnection($workerId = null) {
        self::reset($workerId);
    }

    private function __clone() {}
    private function __construct() {}
}