<?php

/**
 * This file is part of the Latte (https://latte.nette.org)
 * Copyright (c) 2008 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Latte\Compiler;

use Latte\Compiler\Nodes\Php as Node;
use Latte\Compiler\Nodes\Php\Expression;
use Latte\Compiler\Nodes\Php\Scalar;
use function array_pop, count, is_string, substr;


/** @internal generated trait used by TagParser */
abstract class TagParserData
{
	/** Symbol number of error recovery token */
	protected const ErrorSymbol = 1;

	/** Action number signifying default action */
	protected const DefaultAction = -8190;

	/** Rule number signifying that an unexpected token was encountered */
	protected const UnexpectedTokenRule = 8191;

	protected const Yy2Tblstate = 264;

	/** Number of non-leaf states */
	protected const NumNonLeafStates = 361;

	/** Map of lexer tokens to internal symbols */
	protected const TokenToSymbol = [
		0,     115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   50,    110,   115,   111,   49,    115,   115,
		104,   105,   47,    45,    2,     46,    41,    48,    115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   22,    108,
		36,    7,     38,    21,    61,    115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   63,    115,   109,   28,    115,   115,   102,   115,   115,
		115,   100,   103,   115,   115,   115,   115,   115,   115,   101,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   106,   26,    107,   52,    115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,
		115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   115,   1,     3,     4,     5,
		6,     8,     9,     10,    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,    23,    24,    25,    27,    29,    30,
		31,    32,    33,    34,    35,    37,    39,    40,    42,    43,    44,    51,    53,    54,    55,    56,    57,    58,    59,    60,
		62,    64,    65,    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
		83,    84,    85,    86,    87,    88,    89,    90,    91,    92,    112,   93,    94,    95,    96,    113,   114,   97,    98,    99,
	];

	/** Map of states to a displacement into the self::Action table. The corresponding action for this
	 *  state/symbol pair is self::Action[self::ActionBase[$state] + $symbol]. If self::ActionBase[$state] is 0, the
	 *  action is defaulted, i.e. self::ActionDefault[$state] should be used instead. */
	protected const ActionBase = [
		213,   316,   316,   316,   316,   101,   144,   316,   273,   187,   230,   316,   398,   398,   398,   310,   310,   310,   310,   297,
		297,   287,   282,   359,   360,   365,   366,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,
		-45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,
		-45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,
		-45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,
		-45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   7,     255,   264,   389,   392,   390,   393,   420,   421,   417,
		427,   440,   52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    193,   121,   196,   326,
		326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   326,   224,   224,   224,
		181,   564,   557,   512,   404,   527,   527,   478,   478,   478,   478,   478,   -32,   58,    117,   117,   117,   117,   455,   455,
		382,   382,   382,   382,   382,   382,   382,   382,   382,   241,   290,   142,   142,   143,   189,   185,   185,   185,   185,   116,
		116,   116,   116,   116,   116,   116,   279,   70,    70,    70,    507,   510,   513,   523,   280,   40,    40,    40,    40,    40,
		40,    283,   267,   462,   537,   537,   540,   208,   208,   537,   200,   114,   -8,    -15,   305,   322,   141,   45,    127,   2,
		367,   271,   275,   292,   22,    299,   310,   447,   447,   310,   310,   310,   385,   74,    74,    74,    -64,   -46,   162,   293,
		395,   293,   293,   293,   217,   -76,   309,   332,   333,   309,   65,    334,   334,   118,   69,    335,   336,   334,   334,   165,
		69,    69,    281,   289,   300,   191,   111,   300,   288,   288,   173,   35,    339,   337,   340,   331,   330,   320,   223,   268,
		284,   278,   329,   265,   339,   337,   340,   277,   6,     325,   327,   285,   285,   285,   285,   285,   285,   285,   285,   285,
		285,   223,   396,   47,    295,   343,   344,   17,    350,   354,   345,   294,   407,   285,   296,   321,   270,   430,   328,   27,
		223,   434,   269,   274,   298,   349,   286,   435,   355,   304,   413,   201,   347,   205,   414,   252,   324,   272,   356,   291,
		415,   0,     -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,
		-45,   -45,   -45,   -45,   -45,   -45,   -45,   -45,   0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     52,    52,    52,    52,    52,    52,    52,    52,    52,
		52,    52,    52,    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     52,    52,    52,
		52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,
		52,    52,    52,    52,    52,    0,     52,    52,    52,    52,    52,    52,    52,    58,    0,     70,    70,    70,    70,    102,
		102,   102,   102,   102,   102,   102,   102,   102,   102,   102,   70,    70,    102,   102,   102,   102,   102,   102,   102,   102,
		102,   102,   102,   102,   102,   102,   102,   0,     0,     0,     0,     0,     0,     0,     0,     200,   288,   288,   288,   288,
		288,   288,   200,   200,   0,     0,     0,     0,     70,    70,    0,     0,     200,   288,   0,     0,     0,     0,     0,     0,
		0,     310,   310,   310,   200,   334,   0,     0,     288,   288,   0,     0,     0,     309,   0,     0,     0,     0,     0,     0,
		285,   47,    285,   285,   285,
	];

	/** Table of actions. Indexed according to self::ActionBase comment. */
	protected const Action = [
		33,    34,    -278,  31,    -278,  35,    -50,   36,    180,   181,   37,    38,    39,    40,    41,    42,    43,    -48,   1,     195,
		44,    571,   572,   210,   12,    553,   388,   -47,   -191,  569,   292,   533,   249,   250,   173,   0,     293,   294,   346,   388,
		-191,  295,   296,   214,   13,    -80,   -190,  -80,   -230,  7,     555,   554,   577,   575,   576,   53,    54,    55,    -190,  28,
		657,   369,   370,   368,   658,   230,   297,   11,    -230,  -230,  -230,  14,    -80,   22,    99,    56,    57,    58,    59,    297,
		60,    61,    62,    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
		80,    81,    379,   198,   369,   370,   368,   -278,  386,   373,   387,   -278,  213,   20,    82,    77,    78,    79,    80,    81,
		102,   198,   372,   371,   -8190, -8190, 383,   -276,  384,   -276,  367,   366,   82,    376,   375,   378,   377,   374,   380,   381,
		382,   -274,  386,   -274,  387,   379,   100,   369,   370,   368,   -80,   297,   373,   -8191, -8191, -8191, -8191, 72,    73,    74,
		75,    76,    -47,   199,   199,   196,   45,    193,   179,   206,   551,   303,   553,   367,   366,   240,   304,   375,   241,   242,
		374,   380,   305,   306,   -8190, -8190, -8190, -8190, 379,   423,   369,   370,   368,   390,   23,    373,   -8190, 555,   554,   -8190,
		-8190, -8190, -8190, 580,   -8190, -8190, 436,   106,   196,   45,    199,   107,   206,   425,   303,   424,   367,   366,   104,   304,
		375,   241,   242,   374,   380,   305,   306,   -8190, -8190, -8190, 96,    379,   -276,  369,   370,   368,   -276,  24,    373,   425,
		425,   424,   424,   203,   204,   -8190, -274,  -52,   -29,   436,   -274,  196,   45,    -8190, -8190, 206,   388,   303,   108,   367,
		366,   16,    304,   375,   241,   242,   374,   380,   305,   306,   18,    388,   -8190, 646,   379,   97,    369,   370,   368,   109,
		25,    373,   73,    74,    75,    76,    425,   -23,   424,   49,    21,    184,   436,   -17,   196,   45,    297,   -16,   206,   17,
		303,   -22,   367,   366,   98,    304,   375,   241,   242,   374,   380,   305,   306,   32,    266,   3,     178,   379,   105,   369,
		370,   368,   194,   26,    373,   200,   201,   205,   202,   -8190, -8190, -8190, 74,    75,    76,    436,   173,   196,   45,    367,
		366,   206,   -231,  303,   198,   367,   366,   82,    304,   375,   241,   242,   374,   380,   305,   306,   330,   103,   659,   388,
		379,   352,   -231,  -231,  -231,  -8190, 101,   373,   29,    581,   -199,  -190,  582,   285,   -261,  19,    172,   570,   436,   282,
		196,   45,    398,   -190,  206,   232,   303,   247,   215,   216,   217,   304,   375,   241,   242,   374,   380,   305,   306,   360,
		0,     369,   370,   368,   0,     253,   254,   255,   -260,  46,    47,    15,    83,    84,    85,    86,    87,    88,    89,    90,
		91,    92,    93,    94,    95,    -259,  52,    367,   366,   -235,  265,   -234,  -233,  -232,  2,     4,     5,     6,     8,     9,
		10,    27,    379,   50,    51,    1,     197,   191,   192,   373,   257,   246,   654,   388,   284,   521,   569,   477,   479,   567,
		437,   539,   196,   45,    545,   547,   206,   -224,  303,   296,   549,   601,   -29,   304,   375,   241,   242,   374,   380,   305,
		306,   -8190, -8190, -8190, 367,   366,   48,    -224,  -224,  -224,  516,   101,   230,   297,   338,   342,   -224,  558,   522,   -8190,
		626,   -8190, -8190, -8190, -8190, 566,   -8190, -8190, -8190, -8191, -8191, -8191, -8191, -8191, 656,   -8190, -8190, -8190, 1,     197,
		399,   655,   532,   257,   349,   -227,  388,   653,   610,   569,   -8190, -8190, -8190, -8190, 624,   -8190, -8190, -8190, -8190, 598,
		-8190, 295,   296,   614,   649,   -227,  -227,  -227,  -8190, 354,   -8190, -8190, -8190, -8190, -227,  -8190, -8190, -8190, 297,   48,
		-8190, -8190, -8190, 0,     0,     230,   297,   -8190, -8190, -8190, -231,  0,     0,     -228,  0,     0,     -226,  0,     -8190, 0,
		-8190, -8190, -8190, -8190, 0,     -8190, -225,  -8190, -8190, -8190, -231,  -231,  -231,  -228,  -228,  -228,  -226,  -226,  -226,  -190,
		-224,  0,     -228,  30,    0,     -226,  -225,  -225,  -225,  0,     0,     -190,  0,     0,     -235,  -225,  0,     -234,  0,     0,
		-224,  -224,  -224,  218,   219,   220,   0,     -233,  0,     -224,  0,     0,     248,
	];

	/** Table indexed analogously to self::Action. If self::ActionCheck[self::ActionBase[$state] + $symbol] != $symbol
	 *  then the action is defaulted, i.e. self::ActionDefault[$state] should be used instead. */
	protected const ActionCheck = [
		45,    46,    0,     79,    2,     50,    0,     52,    53,    54,    55,    56,    57,    58,    59,    60,    61,    0,     63,    64,
		65,    66,    67,    68,    2,     70,    71,    0,     92,    74,    75,    107,   77,    78,    27,    0,     81,    82,    46,    71,
		104,   86,    87,    88,    22,    0,     92,    2,     63,    2,     95,    96,    97,    98,    99,    3,     4,     5,     104,   104,
		68,    3,     4,     5,     72,    110,   111,   2,     83,    84,    85,    2,     27,    21,    106,   23,    24,    25,    26,    111,
		28,    29,    30,    31,    32,    33,    34,    35,    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
		48,    49,    44,    51,    3,     4,     5,     105,   68,    51,    70,    109,   105,   2,     62,    45,    46,    47,    48,    49,
		2,     51,    64,    65,    3,     4,     68,    0,     70,    2,     29,    30,    62,    75,    76,    77,    78,    79,    80,    81,
		82,    0,     68,    2,     70,    44,    106,   3,     4,     5,     105,   111,   51,    36,    37,    38,    39,    40,    41,    42,
		43,    44,    0,     21,    21,    64,    65,    2,     6,     68,    68,    70,    70,    29,    30,    2,     75,    76,    77,    78,
		79,    80,    81,    82,    3,     4,     5,     73,    44,    87,    3,     4,     5,     2,     93,    51,    3,     95,    96,    3,
		4,     5,     21,    89,    23,    24,    105,   6,     64,    65,    21,    6,     68,    97,    70,    99,    29,    30,    22,    75,
		76,    77,    78,    79,    80,    81,    82,    3,     4,     5,     7,     44,    105,   3,     4,     5,     109,   93,    51,    97,
		97,    99,    99,    26,    27,    21,    105,   105,   105,   105,   109,   64,    65,    45,    46,    68,    71,    70,    6,     29,
		30,    6,     75,    76,    77,    78,    79,    80,    81,    82,    6,     71,    87,    73,    44,    7,     3,     4,     5,     7,
		93,    51,    41,    42,    43,    44,    97,    22,    99,    104,   90,    91,    105,   22,    64,    65,    111,   22,    68,    22,
		70,    22,    29,    30,    22,    75,    76,    77,    78,    79,    80,    81,    82,    100,   101,   102,   103,   44,    22,    3,
		4,     5,     22,    93,    51,    26,    27,    29,    29,    3,     4,     5,     42,    43,    44,    105,   27,    64,    65,    29,
		30,    68,    63,    70,    51,    29,    30,    62,    75,    76,    77,    78,    79,    80,    81,    82,    69,    63,    72,    71,
		44,    80,    83,    84,    85,    73,    93,    51,    63,    89,    92,    92,    89,    76,    104,   106,   92,    110,   105,   105,
		64,    65,    93,    104,   68,    63,    70,    92,    83,    84,    85,    75,    76,    77,    78,    79,    80,    81,    82,    108,
		-1,    3,     4,     5,     -1,    83,    84,    85,    104,   93,    94,    7,     8,     9,     10,    11,    12,    13,    14,    15,
		16,    17,    18,    19,    20,    104,   106,   29,    30,    104,   106,   104,   104,   104,   104,   104,   104,   104,   104,   104,
		104,   104,   44,    104,   104,   63,    64,    104,   104,   51,    68,    104,   107,   71,    105,   105,   74,    53,    54,    105,
		105,   105,   64,    65,    105,   105,   68,    63,    70,    87,    105,   105,   105,   75,    76,    77,    78,    79,    80,    81,
		82,    3,     4,     5,     29,    30,    104,   83,    84,    85,    105,   93,    110,   111,   105,   105,   92,    105,   105,   21,
		105,   23,    24,    25,    26,    109,   28,    29,    30,    31,    32,    33,    34,    35,    107,   3,     4,     5,     63,    64,
		107,   107,   107,   68,    107,   63,    71,    107,   107,   74,    3,     4,     5,     21,    107,   23,    24,    25,    26,    109,
		28,    86,    87,    109,   109,   83,    84,    85,    21,    109,   23,    24,    25,    26,    92,    28,    29,    30,    111,   104,
		3,     4,     5,     -1,    -1,    110,   111,   3,     4,     5,     63,    -1,    -1,    63,    -1,    -1,    63,    -1,    21,    -1,
		23,    24,    25,    26,    -1,    21,    63,    23,    24,    25,    83,    84,    85,    83,    84,    85,    83,    84,    85,    92,
		63,    -1,    92,    63,    -1,    92,    83,    84,    85,    -1,    -1,    104,   -1,    -1,    104,   92,    -1,    104,   -1,    -1,
		83,    84,    85,    83,    84,    85,    -1,    104,   -1,    92,    -1,    -1,    92,
	];

	/** Map of states to their default action */
	protected const ActionDefault = [
		8191,  272,   272,   31,    272,   8191,  8191,  272,   8191,  8191,  8191,  29,    8191,  8191,  29,    8191,  8191,  8191,  8191,  39,
		29,    8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  222,   222,   222,   8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  10,    8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  29,    8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  273,   273,   8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  1,     279,   280,   85,    79,    223,   275,   277,   81,    84,    82,    43,    44,    56,    122,   124,   158,   123,
		98,    103,   104,   105,   106,   107,   108,   109,   110,   111,   112,   113,   114,   115,   96,    97,    170,   159,   157,   156,
		120,   121,   125,   128,   95,    126,   127,   145,   146,   143,   144,   147,   8191,  8191,  148,   149,   150,   151,   8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  152,   129,   71,    71,    71,    8191,  8191,  11,    8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  213,   135,   136,   138,   213,   175,   212,   154,   8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  218,   117,   119,   196,   130,   131,   99,    8191,  8191,  8191,  217,   8191,  287,   224,   224,   224,   224,
		34,    34,    34,    8191,  91,    57,    34,    8191,  8191,  34,    34,    34,    8191,  8191,  8191,  8191,  202,   231,   224,   141,
		8191,  132,   133,   134,   59,    8191,  8191,  189,   8191,  2,     28,    174,   8191,  28,    28,    8191,  245,   246,   247,   28,
		28,    28,    177,   36,    73,    28,    28,    73,    8191,  8191,  28,    8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  207,
		8191,  229,   243,   192,   15,    20,    21,    8191,  207,   228,   226,   139,   140,   142,   162,   163,   164,   165,   166,   167,
		168,   270,   8191,  266,   195,   8191,  8191,  224,   8191,  8191,  286,   8191,  224,   137,   8191,  203,   250,   8191,  225,   224,
		271,   8191,  8191,  8191,  60,    8191,  8191,  8191,  8191,  204,   8191,  8191,  8191,  8191,  8191,  8191,  8191,  55,    8191,  8191,
		8191,
	];

	/** Map of non-terminals to a displacement into the self::Goto table. The corresponding goto state for this
	 *  non-terminal/state pair is self::Goto[self::GotoBase[$nonTerminal] + $state] (unless defaulted) */
	protected const GotoBase = [
		0,     0,     -1,    0,     0,     0,     108,   0,     247,   -246,  31,    -14,   0,     1,     47,    0,     0,     0,     0,     -7,
		95,    68,    -20,   276,   -9,    63,    0,     64,    0,     70,    104,   0,     0,     -64,   -8,    24,    101,   232,   0,     0,
		4,     0,     0,     -77,   0,     0,     86,    6,     0,     0,     0,     38,    0,     0,     0,     0,     33,    -49,   0,     0,
		0,     28,    39,    3,     56,    45,    55,    0,     0,     -15,   -21,   0,     34,    7,     111,   81,    0,     0,
	];

	/** Table of states to goto after reduction. Indexed according to self::GotoBase comment. */
	protected const Goto = [
		112,   112,   111,   112,   393,   329,   112,   650,   651,   652,   111,   260,   394,   403,   140,   128,   129,   128,   125,   125,
		117,   138,   130,   130,   130,   130,   125,   110,   127,   127,   127,   122,   311,   312,   259,   313,   314,   315,   316,   317,
		318,   319,   320,   463,   463,   123,   124,   113,   114,   115,   116,   118,   136,   137,   139,   157,   160,   161,   162,   163,
		165,   166,   167,   168,   169,   170,   171,   174,   175,   176,   177,   189,   190,   207,   208,   209,   227,   228,   261,   262,
		263,   333,   141,   142,   143,   144,   145,   146,   147,   148,   149,   150,   151,   152,   153,   154,   155,   158,   119,   120,
		130,   131,   121,   159,   132,   133,   156,   134,   135,   182,   182,   182,   182,   280,   281,   182,   341,   359,   628,   182,
		272,   514,   328,   185,   187,   188,   187,   422,   422,   422,   422,   550,   550,   550,   550,   422,   422,   422,   422,   422,
		422,   422,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   552,   336,   258,   339,
		224,   225,   236,   327,   332,   229,   237,   238,   239,   308,   308,   568,   568,   568,   568,   568,   568,   568,   568,   568,
		613,   613,   613,   613,   309,   309,   309,   309,   309,   309,   309,   309,   309,   309,   309,   277,   278,   615,   616,   617,
		625,   625,   625,   625,   625,   625,   591,   591,   591,   591,   591,   591,   591,   591,   591,   591,   591,   588,   588,   588,
		588,   588,   588,   588,   588,   588,   588,   588,   324,   324,   324,   324,   611,   611,   310,   310,   310,   310,   310,   310,
		310,   310,   310,   310,   310,   235,   439,   407,   307,   307,   307,   307,   235,   235,   307,   345,   448,   415,   307,   444,
		348,   235,   235,   660,   435,   412,   454,   453,   455,   231,   449,   355,   401,   450,   235,   222,   540,   321,   321,   356,
		321,   618,   619,   321,   541,   243,   183,   183,   325,   326,   0,     544,   546,   0,     340,   644,   325,   326,   283,   548,
		600,   602,   603,   419,   426,   428,   430,   427,   429,   431,   0,     644,   645,   0,     0,     0,     0,     0,     0,     357,
		543,   0,     0,     0,     645,   0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     396,   396,   396,   0,     0,     0,     396,   0,     0,     396,   396,   396,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     335,
		244,   0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     410,   410,
	];

	/** Table indexed analogously to self::Goto. If self::GotoCheck[self::GotoBase[$nonTerminal] + $state] != $nonTerminal
	 *  then the goto state is defaulted, i.e. self::GotoDefault[$nonTerminal] should be used. */
	protected const GotoCheck = [
		2,     2,     2,     2,     13,    63,    2,     9,     9,     9,     2,     73,    13,    19,    2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     6,     6,     6,     6,     36,    36,    6,     46,    46,    74,    6,
		43,    43,    20,    6,     6,     6,     6,     33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,
		33,    33,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,    69,    22,    22,
		22,    22,    22,    22,    22,    22,    22,    22,    22,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,
		69,    69,    69,    69,    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,    70,    70,    70,    70,    70,
		69,    69,    69,    69,    69,    69,    61,    61,    61,    61,    61,    61,    61,    61,    61,    61,    61,    62,    62,    62,
		62,    62,    62,    62,    62,    62,    62,    62,    56,    56,    56,    56,    69,    69,    64,    64,    64,    64,    64,    64,
		64,    64,    64,    64,    64,    10,    37,    21,    8,     8,     8,     8,     10,    10,    8,     25,    40,    27,    8,     11,
		11,    10,    10,    10,    29,    11,    11,    11,    35,    66,    40,    11,    11,    40,    10,    65,    11,    23,    23,    34,
		23,    72,    72,    23,    51,    66,    6,     6,     14,    14,    -1,    35,    35,    -1,    23,    75,    14,    14,    14,    35,
		35,    35,    35,    30,    30,    30,    30,    30,    30,    30,    -1,    75,    75,    -1,    -1,    -1,    -1,    -1,    -1,    10,
		10,    -1,    -1,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    6,     6,     6,     -1,    -1,    -1,    6,     -1,    -1,    6,     6,     6,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    8,
		8,     -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    23,
	];

	/** Map of non-terminals to the default state to goto after their reduction */
	protected const GotoDefault = [
		-8192, 291,   126,   269,   364,   365,   186,   385,   334,   623,   609,   391,   270,   630,   289,   288,   462,   350,   286,   402,
		351,   406,   164,   298,   299,   343,   279,   414,   251,   433,   245,   264,   344,   267,   353,   534,   274,   438,   273,   252,
		447,   451,   461,   271,   530,   287,   337,   211,   537,   358,   290,   542,   599,   268,   300,   275,   559,   256,   226,   301,
		-8192, 233,   223,   322,   212,   221,   643,   234,   302,   597,   276,   605,   612,   323,   629,   642,   331,   347,
	];

	/** Map of rules to the non-terminal on their left-hand side, i.e. the non-terminal to use for
	 *  determining the state to goto after reduction. */
	protected const RuleToNonTerminal = [
		0,     1,     1,     1,     1,     6,     6,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
		7,     7,     8,     8,     8,     9,     9,     10,    11,    11,    4,     4,     12,    12,    14,    14,    15,    15,    16,    17,
		17,    18,    18,    19,    19,    5,     5,     21,    21,    21,    21,    25,    25,    26,    26,    27,    27,    29,    29,    29,
		29,    30,    30,    30,    30,    31,    31,    31,    31,    32,    32,    28,    28,    34,    34,    35,    35,    36,    36,    37,
		37,    37,    37,    20,    38,    38,    39,    39,    3,     3,     40,    41,    41,    41,    41,    2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     47,    48,    42,    42,    45,    45,    49,
		50,    50,    51,    52,    52,    52,    52,    52,    52,    56,    33,    33,    57,    57,    57,    43,    43,    43,    54,    54,
		60,    60,    61,    62,    62,    24,    64,    64,    64,    64,    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
		44,    44,    46,    46,    59,    59,    59,    59,    59,    67,    67,    67,    53,    53,    53,    53,    68,    68,    68,    68,
		68,    68,    68,    22,    22,    22,    22,    22,    69,    69,    72,    71,    58,    58,    58,    58,    58,    58,    58,    55,
		55,    55,    70,    70,    70,    23,    63,    73,    73,    74,    74,    74,    74,    13,    13,    13,    13,    13,    13,    13,
		13,    65,    65,    65,    65,    66,    76,    75,    75,    75,    75,    75,    75,    75,    75,    75,    77,    77,    77,    77,
	];

	/** Map of rules to the length of their right-hand side, which is the number of elements that have to
	 *  be popped from the stack(s) on reduction. */
	protected const RuleToLength = [
		1,     2,     2,     2,     2,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
		1,     1,     1,     1,     1,     1,     1,     1,     0,     1,     2,     0,     1,     3,     0,     1,     0,     1,     7,     0,
		2,     1,     3,     3,     4,     1,     3,     1,     2,     1,     1,     2,     0,     1,     3,     4,     6,     1,     2,     1,
		1,     1,     1,     1,     1,     3,     3,     3,     3,     3,     3,     0,     1,     0,     2,     2,     4,     1,     3,     1,
		2,     2,     3,     2,     3,     1,     2,     2,     1,     2,     3,     0,     3,     3,     1,     1,     3,     3,     3,     4,
		1,     1,     2,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     2,     2,     2,     2,
		3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
		2,     2,     2,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     5,     4,     3,     3,
		4,     4,     2,     2,     2,     2,     2,     2,     2,     1,     8,     12,    9,     3,     2,     1,     1,     0,     4,     2,
		1,     3,     2,     2,     4,     2,     4,     4,     6,     1,     1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
		0,     1,     1,     3,     5,     3,     4,     1,     1,     3,     1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
		2,     3,     0,     1,     1,     3,     1,     1,     1,     1,     1,     1,     1,     3,     1,     1,     1,     4,     1,     4,
		6,     4,     4,     1,     1,     3,     3,     3,     1,     4,     1,     3,     1,     4,     3,     3,     3,     3,     3,     1,
		3,     1,     1,     3,     1,     4,     1,     3,     1,     1,     1,     3,     0,     1,     2,     3,     4,     3,     4,     2,
		2,     2,     2,     1,     2,     1,     1,     1,     4,     3,     3,     3,     3,     3,     6,     3,     1,     1,     2,     1,
	];

	/** Map of symbols to their names */
	protected const SymbolToName = [
		'end',
		'error',
		"','",
		"'or'",
		"'xor'",
		"'and'",
		"'=>'",
		"'='",
		"'+='",
		"'-='",
		"'*='",
		"'/='",
		"'.='",
		"'%='",
		"'&='",
		"'|='",
		"'^='",
		"'<<='",
		"'>>='",
		"'**='",
		"'??='",
		"'?'",
		"':'",
		"'??'",
		"'||'",
		"'&&'",
		"'|'",
		"'|'",
		"'^'",
		"'&'",
		"'&'",
		"'=='",
		"'!='",
		"'==='",
		"'!=='",
		"'<=>'",
		"'<'",
		"'<='",
		"'>'",
		"'>='",
		"'|>'",
		"'.'",
		"'<<'",
		"'>>'",
		"'in'",
		"'+'",
		"'-'",
		"'*'",
		"'/'",
		"'%'",
		"'!'",
		"'instanceof'",
		"'~'",
		"'++'",
		"'--'",
		"'(int)'",
		"'(float'",
		"'(string)'",
		"'(array)'",
		"'(object)'",
		"'(bool)'",
		"'@'",
		"'**'",
		"'['",
		"'new'",
		"'clone'",
		'integer',
		'floating-point number',
		'identifier',
		'variable name',
		'constant',
		'variable',
		'number',
		'string content',
		'quoted string',
		"'match'",
		"'default'",
		"'function'",
		"'fn'",
		"'return'",
		"'use'",
		"'isset'",
		"'empty'",
		"'->'",
		"'?->'",
		"'??->'",
		"'list'",
		"'array'",
		"'heredoc start'",
		"'heredoc end'",
		"'\${'",
		"'{\$'",
		"'::'",
		"'...'",
		"'(expand)'",
		'fully qualified name',
		'namespaced name',
		"'null'",
		"'true'",
		"'false'",
		"'e'",
		"'m'",
		"'a'",
		"'f'",
		"'('",
		"')'",
		"'{'",
		"'}'",
		"';'",
		"']'",
		"'\"'",
		"'$'",
		"'\\\\'",
		'whitespace',
		'comment',
	];

	/** Temporary value containing the result of last semantic action (reduction) */
	protected mixed $semValue = null;

	/** Semantic value stack (contains values of tokens and semantic action results) */
	protected array $semStack;

	/** @var Token[] Start attribute stack */
	protected array $startTokenStack;


	protected function reduce(int $rule, int $pos): void
	{
		(match ($rule) {
			0, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 28, 29, 57, 72, 74, 94, 95, 100, 101, 169, 175, 176, 189, 191, 195, 196, 198, 199, 201, 212, 217, 218, 223, 224, 226, 227, 228, 229, 230, 232, 234, 235, 236, 238, 243, 244, 248, 252, 259, 261, 262, 264, 269, 287, 299 => fn() => $this->semValue = $this->semStack[$pos],
			2 => fn() => $this->semValue = new Node\ModifierNode($this->semStack[$pos], position: $this->startTokenStack[$pos]->position),
			3 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos], position: $this->startTokenStack[$pos]->position),
			22, 23, 24, 25, 26, 62, 63, 64 => fn() => $this->semValue = new Node\IdentifierNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			27 => fn() => $this->semValue = new Expression\VariableNode(substr($this->semStack[$pos], 1), $this->startTokenStack[$pos]->position),
			30, 40, 51, 83, 92, 93, 154, 155, 178, 179, 197, 225, 233, 260, 263, 295 => fn() => $this->semValue = $this->semStack[$pos - 1],
			31, 39, 52, 75, 91, 177, 200 => fn() => $this->semValue = [],
			32, 41, 53, 77, 85, 88, 180, 268, 283 => fn() => $this->semValue = [$this->semStack[$pos]],
			33, 42, 54, 66, 68, 70, 78, 84, 181, 267 => function () use ($pos) {
				$this->semStack[$pos - 2][] = $this->semStack[$pos];
				$this->semValue = $this->semStack[$pos - 2];
			},
			34, 36 => fn() => $this->semValue = false,
			35, 37 => fn() => $this->semValue = true,
			38 => fn() => $this->semValue = new Expression\MatchNode($this->semStack[$pos - 4], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 6]->position),
			43 => fn() => $this->semValue = new Node\MatchArmNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			44 => fn() => $this->semValue = new Node\MatchArmNode(null, $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			45 => fn() => $this->semValue = [null, ...$this->semStack[$pos]],
			46 => fn() => $this->semValue = [$this->semStack[$pos - 2], ...$this->semStack[$pos]],
			47, 49 => fn() => $this->semValue = [$this->semStack[$pos], false],
			48 => fn() => $this->semValue = [$this->semStack[$pos], true],
			50 => fn() => $this->semValue = [$this->convertArrayToList($this->semStack[$pos]), false],
			55 => fn() => $this->semValue = new Node\ParameterNode($this->semStack[$pos], null, $this->semStack[$pos - 3], $this->semStack[$pos - 2], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			56 => fn() => $this->semValue = new Node\ParameterNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->semStack[$pos - 5], $this->semStack[$pos - 4], $this->semStack[$pos - 3], $this->startTokenStack[$pos - 5]->position),
			58 => fn() => $this->semValue = new Node\NullableTypeNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			59 => fn() => $this->semValue = new Node\UnionTypeNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			60 => fn() => $this->semValue = new Node\IntersectionTypeNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			61 => fn() => $this->semValue = TagParser::handleBuiltinTypes($this->semStack[$pos]),
			65, 67, 69 => fn() => $this->semValue = [$this->semStack[$pos - 2], $this->semStack[$pos]],
			71, 73, 222 => fn() => $this->semValue = null,
			76 => fn() => $this->semValue = $this->semStack[$pos - 2],
			79 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, false, null, $this->startTokenStack[$pos]->position),
			80 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], true, false, null, $this->startTokenStack[$pos - 1]->position),
			81 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, true, null, $this->startTokenStack[$pos - 1]->position),
			82 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, false, $this->semStack[$pos - 2], $this->startTokenStack[$pos - 2]->position),
			86, 87 => fn() => $this->semValue = new Expression\FilterCallNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			89, 281, 282 => function () use ($pos) {
				$this->semStack[$pos - 1][] = $this->semStack[$pos];
				$this->semValue = $this->semStack[$pos - 1];
			},
			90 => fn() => $this->semValue = new Node\FilterNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			96, 98 => fn() => $this->semValue = new Expression\AssignNode($this->semStack[$pos - 2], $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			97 => fn() => $this->semValue = new Expression\AssignNode($this->convertArrayToList($this->semStack[$pos - 2]), $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			99 => fn() => $this->semValue = new Expression\AssignNode($this->semStack[$pos - 3], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position),
			102 => fn() => $this->semValue = new Expression\CloneNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			103 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '+', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			104 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '-', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			105 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '*', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			106 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '/', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			107 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '.', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			108 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '%', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			109 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			110 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '|', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			111 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '^', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			112 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '<<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			113 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '>>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			114 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '**', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			115 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '??', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			116 => fn() => $this->semValue = new Expression\PostOpNode($this->semStack[$pos - 1], '++', $this->startTokenStack[$pos - 1]->position),
			117 => fn() => $this->semValue = new Expression\PreOpNode($this->semStack[$pos], '++', $this->startTokenStack[$pos - 1]->position),
			118 => fn() => $this->semValue = new Expression\PostOpNode($this->semStack[$pos - 1], '--', $this->startTokenStack[$pos - 1]->position),
			119 => fn() => $this->semValue = new Expression\PreOpNode($this->semStack[$pos], '--', $this->startTokenStack[$pos - 1]->position),
			120 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '||', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			121 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '&&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			122 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'or', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			123 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'and', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			124 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'xor', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			125 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '|', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			126, 127 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			128 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '^', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			129 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '.', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			130 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '+', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			131 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '-', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			132 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '*', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			133 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '/', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			134 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '%', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			135 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			136 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			137 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '**', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			138 => fn() => $this->semValue = new Expression\InNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			139 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '+', $this->startTokenStack[$pos - 1]->position),
			140 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '-', $this->startTokenStack[$pos - 1]->position),
			141 => fn() => $this->semValue = new Expression\NotNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			142 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '~', $this->startTokenStack[$pos - 1]->position),
			143 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '===', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			144 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '!==', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			145 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '==', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			146 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '!=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			147 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<=>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			148 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			149 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			150 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			151 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			152 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '|>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			153 => fn() => $this->semValue = new Expression\InstanceofNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			156 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 4], $this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 4]->position),
			157 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 3], null, $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			158 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 2], $this->semStack[$pos], null, $this->startTokenStack[$pos - 2]->position),
			159 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '??', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			160 => fn() => $this->semValue = new Expression\IssetNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			161 => fn() => $this->semValue = new Expression\EmptyNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			162 => fn() => $this->semValue = new Expression\CastNode('int', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			163 => fn() => $this->semValue = new Expression\CastNode('float', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			164 => fn() => $this->semValue = new Expression\CastNode('string', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			165 => fn() => $this->semValue = new Expression\CastNode('array', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			166 => fn() => $this->semValue = new Expression\CastNode('object', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			167 => fn() => $this->semValue = new Expression\CastNode('bool', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			168 => fn() => $this->semValue = new Expression\ErrorSuppressNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			170 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 6], $this->semStack[$pos - 4], [], $this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 7]->position),
			171 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 10], $this->semStack[$pos - 8], $this->semStack[$pos - 6], $this->semStack[$pos - 5], $this->semStack[$pos - 2], $this->startTokenStack[$pos - 11]->position),
			172 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 7], $this->semStack[$pos - 5], $this->semStack[$pos - 3], $this->semStack[$pos - 2], null, $this->startTokenStack[$pos - 8]->position),
			173 => fn() => $this->semValue = new Expression\NewNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			174 => fn() => $this->semValue = new Expression\NewNode($this->semStack[$pos], [], $this->startTokenStack[$pos - 1]->position),
			182 => fn() => $this->semValue = new Node\ClosureUseNode($this->semStack[$pos], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 1]->position),
			183, 185 => fn() => $this->semValue = $this->checkFunctionName(new Expression\FunctionCallNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position)),
			184, 186 => fn() => $this->semValue = $this->checkFunctionName(new Expression\FunctionCallableNode($this->semStack[$pos - 3], $this->startTokenStack[$pos - 3]->position)),
			187 => fn() => $this->semValue = new Expression\StaticMethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			188 => fn() => $this->semValue = new Expression\StaticMethodCallableNode($this->semStack[$pos - 5], $this->semStack[$pos - 3], $this->startTokenStack[$pos - 5]->position),
			190, 192, 193 => fn() => $this->semValue = new Node\NameNode($this->semStack[$pos], Node\NameNode::KindNormal, $this->startTokenStack[$pos]->position),
			194 => fn() => $this->semValue = new Node\NameNode($this->semStack[$pos], Node\NameNode::KindFullyQualified, $this->startTokenStack[$pos]->position),
			202 => fn() => $this->semValue = new Expression\ConstantFetchNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			203 => fn() => $this->semValue = new Expression\ClassConstantFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			204 => fn() => $this->semValue = new Expression\ClassConstantFetchNode($this->semStack[$pos - 4], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 4]->position),
			205 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			206 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			207 => function () use ($pos) {
				$this->semValue = $this->semStack[$pos];
				$this->shortArrays->offsetSet($this->semValue);
			},
			208 => fn() => $this->semValue = Scalar\StringNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			209 => fn() => $this->semValue = Scalar\InterpolatedStringNode::parse($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			210 => fn() => $this->semValue = Scalar\IntegerNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			211 => fn() => $this->semValue = Scalar\FloatNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			213, 296 => fn() => $this->semValue = new Scalar\StringNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			214 => fn() => $this->semValue = new Scalar\BooleanNode(true, $this->startTokenStack[$pos]->position),
			215 => fn() => $this->semValue = new Scalar\BooleanNode(false, $this->startTokenStack[$pos]->position),
			216 => fn() => $this->semValue = new Scalar\NullNode($this->startTokenStack[$pos]->position),
			219 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 2], [$this->semStack[$pos - 1]], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position, $this->startTokenStack[$pos]->position),
			220 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 1], [], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position, $this->startTokenStack[$pos]->position),
			221 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 2], $this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position, $this->startTokenStack[$pos]->position),
			231 => fn() => $this->semValue = new Expression\ConstantFetchNode(new Node\NameNode($this->semStack[$pos], Node\NameNode::KindNormal, $this->startTokenStack[$pos]->position), $this->startTokenStack[$pos]->position),
			237, 253, 288 => fn() => $this->semValue = new Expression\ArrayAccessNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			239 => fn() => $this->semValue = new Expression\MethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], false, $this->startTokenStack[$pos - 3]->position),
			240 => fn() => $this->semValue = new Expression\MethodCallableNode($this->semStack[$pos - 5], $this->semStack[$pos - 3], $this->startTokenStack[$pos - 5]->position),
			241 => fn() => $this->semValue = new Expression\MethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position),
			242 => fn() => $this->semValue = new Expression\MethodCallNode(new Expression\BinaryOpNode($this->semStack[$pos - 3], '??', new Scalar\NullNode($this->startTokenStack[$pos - 3]->position), $this->startTokenStack[$pos - 3]->position), $this->semStack[$pos - 1], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position),
			245, 254, 289 => fn() => $this->semValue = new Expression\PropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			246, 255, 290 => fn() => $this->semValue = new Expression\PropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], true, $this->startTokenStack[$pos - 2]->position),
			247, 256, 291 => fn() => $this->semValue = new Expression\PropertyFetchNode(new Expression\BinaryOpNode($this->semStack[$pos - 2], '??', new Scalar\NullNode($this->startTokenStack[$pos - 2]->position), $this->startTokenStack[$pos - 2]->position), $this->semStack[$pos], true, $this->startTokenStack[$pos - 2]->position),
			249 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			250 => function () use ($pos) {
				$var = $this->semStack[$pos]->name;
				$this->semValue = is_string($var)
					? new Node\VarLikeIdentifierNode($var, $this->startTokenStack[$pos]->position)
					: $var;
			},
			251, 257, 258 => fn() => $this->semValue = new Expression\StaticPropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			265 => fn() => $this->semValue = $this->convertArrayToList(new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position)),
			266 => function () use ($pos) {
				$this->semValue = $this->semStack[$pos];
				$end = count($this->semValue) - 1;
				if (
					$this->semValue[$end]->value instanceof Expression\TemporaryNode
					&& !$this->semValue[$end]->value->value
				) {
					array_pop($this->semValue);
				}
			},
			270 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode($this->semStack[$pos], $this->startTokenStack[$pos]->position), null, false, false, $this->startTokenStack[$pos]->position),
			271 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode($this->semStack[$pos], $this->startTokenStack[$pos - 2]->position), $this->semStack[$pos - 2], false, false, $this->startTokenStack[$pos - 2]->position),
			272 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode(null), null, false, false, $this->startTokenStack[$pos]->position),
			273 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, false, false, $this->startTokenStack[$pos]->position),
			274 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, true, false, $this->startTokenStack[$pos - 1]->position),
			275, 277 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], $this->semStack[$pos - 2], false, false, $this->startTokenStack[$pos - 2]->position),
			276, 278 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], $this->semStack[$pos - 3], true, false, $this->startTokenStack[$pos - 3]->position),
			279, 280 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, false, true, $this->startTokenStack[$pos - 1]->position),
			284 => fn() => $this->semValue = [$this->semStack[$pos - 1], $this->semStack[$pos]],
			285 => fn() => $this->semValue = new Node\InterpolatedStringPartNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			286 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			292, 293 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			294 => fn() => $this->semValue = new Expression\ArrayAccessNode($this->semStack[$pos - 4], $this->semStack[$pos - 2], $this->startTokenStack[$pos - 5]->position),
			297 => fn() => $this->semValue = TagParser::parseOffset($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			298 => fn() => $this->semValue = TagParser::parseOffset('-' . $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
		})();
	}
}
