<?php

$redirect = null;

$upgrade_info = array();

if (file_exists("upgrade_info.php")) {
  $upgrade_info_content = file_get_contents('upgrade_info.php');
  $upgrade_info_content = json_decode($upgrade_info_content, true);
  if (!empty($upgrade_info_content)) {
    $upgrade_info = $upgrade_info_content;
  }
}

if (!isset($upgrade_info['db']) || empty($upgrade_info['db'])) {
  if ((int) $upgrade_info['grupo_version'] == 2) {
    define('s7V9pz', true);
    include('../key/bit.php');

    $database = cnf('Grupo');

    $upgrade_info['db'] = array();
    $upgrade_info['db']['database'] = $database['db'];
    $upgrade_info['db']['host'] = $database['host'];
    $upgrade_info['db']['username'] = $database['user'];
    $upgrade_info['db']['password'] = $database['pass'];
    $upgrade_info['db']['prefix'] = '';
    $upgrade_info['db']['port'] = 3306;
    $upgrade_info['db']['type'] = 'mysql';
  } elseif ((int) $upgrade_info['grupo_version'] == 3) {
    $database_file = file_get_contents('../include/config.php');
    $database_file = str_replace("include 'fns/registry/load.php';", '', $database_file);
    $database_file = str_replace('Registry::__init();', '', $database_file);
    $database_file = str_replace('Registry::add(' . "'config'" . ', $config);', '', $database_file);
    $database_file = str_replace('date_default_timezone_set($config->timezone);', '', $database_file);
    $database_file = str_replace("<?php", '', $database_file);
    $database = eval ($database_file);

    $database = $config->database;

    $upgrade_info['db'] = array();
    $upgrade_info['db']['database'] = $database['database'];
    $upgrade_info['db']['host'] = $database['host'];
    $upgrade_info['db']['username'] = $database['username'];
    $upgrade_info['db']['password'] = $database['password'];
    $upgrade_info['db']['prefix'] = '';
    $upgrade_info['db']['port'] = $database['port'];
    $upgrade_info['db']['type'] = 'mysql';
  }
}

if (isset($upgrade_info['db']) && !empty($upgrade_info['db'])) {

  $file_content = json_encode($upgrade_info);

  if (file_exists("upgrade_info.php")) {
    unlink("upgrade_info.php");
  }

  file_put_contents("upgrade_info.php", $file_content);

  $GLOBALS["database_info"] = $upgrade_info['db'];

  include('functions/database/load.php');
  try {
    DB::connect();
    $redirect = 'start';
  } catch (PDOException $exception) {
    $system_message = 'Error : Invalid Database Credentials.';
  }
} else {
  if (file_exists("upgrade_info.php")) {
    unlink('upgrade_info.php');
  }
  $system_message = 'Error : Database Verification Failed.';
}

if (!empty($redirect)) {
  $page_content = [
    'title' => 'Starting Upgrade Process',
    'loading_text' => 'Starting Upgrade Process',
    'subtitle' => 'Please Wait',
    'redirect' => 'index.php?process=start'
  ];
} else {
  $page_content = [
    'title' => 'Error',
    'page_content' => $system_message,
    'heading' => 'Oops',
    'page_status' => 'error',
    'button_text' => 'Reload Process',
    'button_link' => 'index.php?process=initial'
  ];
}
