<?php

$upgrade_info=array();

if (file_exists("upgrade_info.php")) {
    $upgrade_info_content = file_get_contents('upgrade_info.php');
    if ($upgrade_info_content !== false) {
        $upgrade_info_content = json_decode($upgrade_info_content, true);
        if (json_last_error() === JSON_ERROR_NONE && !empty($upgrade_info_content)) {
            $upgrade_info = $upgrade_info_content;
        } else {
            $upgrade_info = [];
        }
    } else {
        $upgrade_info = [];
    }
}


if (isset($upgrade_info['db']) && !empty($upgrade_info['db'])) {
    $backup_files= true;

    $folderPath = '../assets/files/storage/';
    
    if (file_exists($folderPath)) {
        if (folderSize($folderPath) > 1) {
            $backup_files= false;
        }
    }

    if ($backup_files && !file_exists('backup')) {
        mkdir('backup', 0755, true);

        include('functions/files/copy.php');
        recurseCopy('../', 'backup');

        include('functions/database/backup_db.php');
        $GLOBALS["database_info"] = $upgrade_info['db'];
        backupDatabase();
    }

    $page_content = [
        'title' => 'Decompressing Upgrade Image File',
        'loading_text' => 'Decompressing Upgrade Image File',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=decompress_image'
    ];
} else {
    if (file_exists("upgrade_info.php")) {
        unlink('upgrade_info.php');
    }

    $page_content = [
               'title' => 'Error',
               'page_content' => 'Error : Upgrade Failed.',
               'heading' => 'OOPS',
               'page_status' => 'error',
               'button_text' => 'Reload Process',
               'button_link' => 'index.php?process=initial'
    ];
}
