<?php

ini_set('max_execution_time', 0);
ini_set('memory_limit', '1024M');
set_time_limit(0);

include('functions/core_fns/load.php');
$process_file = 'processes/prompt.php';

if (isset($_GET['process']) && !empty($_GET['process'])) {
    $_GET['process'] = preg_replace("/[^a-zA-Z0-9_]+/", "", $_GET['process']);
    $temp_process_file = 'processes/' . $_GET['process'] . '.php';

    if (isset($_GET['sub_process']) && !empty($_GET['sub_process'])) {
        $_GET['sub_process'] = preg_replace("/[^a-zA-Z0-9_]+/", "", $_GET['sub_process']);
    }

    if (!empty($_GET['process']) && file_exists($temp_process_file)) {
        if (file_exists('upgrade_info.php') || $_GET['process'] === 'system_requirements' || $_GET['process'] === 'initial') {
            $process_file = $temp_process_file;
        }
    }
}

include($process_file);

$body_class = 'loading_page';

if (isset($page_content['page_status'])) {
    $body_class = $page_content['page_status'];
}
?>

<!DOCTYPE html>
<html>

<head>
    <title><?php echo $page_content['title'] ?></title>
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no shrink-to-fit=no">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link href="resources/css/layout.css" rel="stylesheet">

    <?php if (isset($page_content['redirect'])) {
        if (!isset($page_content['wait_seconds'])) {
            $page_content['wait_seconds'] = 3;
        } ?>
        <meta http-equiv="refresh"
            content="<?php echo $page_content['wait_seconds'] ?>;url=<?php echo $page_content['redirect'] ?>" />
        <?php
    }
    ?>
</head>

<body class="<?php echo $body_class; ?>">

    <?php if (isset($page_content['loading_text'])) {
        ?>
        <div class="preloader">
            <div class="ripple-background">
                <div class="circle xxlarge shade1"></div>
                <div class="circle xlarge shade2"></div>
                <div class="circle large shade3"></div>
                <div class="circle medium shade4"></div>
                <div class="circle small shade5"></div>
            </div>
            <div class="subtitle">
                <?php echo $page_content['subtitle'] ?>
            </div>
            <div class="loading-text">
                <?php echo $page_content['loading_text'] ?>
            </div>
        </div>

        <?php
    } elseif (isset($page_content['heading'])) {
        ?>

        <div class="body_content container">
            <div class="header">
                <h1 class="animated"><?php echo $page_content['heading'] ?></h1>
            </div>
            <div class="contents">

                <?php
                if (isset($page_content['page_content_list'])) {
                    ?>
                    <ul>
                        <?php echo $page_content['page_content_list'] ?>
                    </ul>
                <?php } else { ?>
                    <p>
                        <?php echo $page_content['page_content'] ?>
                    </p>
                <?php } ?>

                <form action="/">
                    <a class="button"
                        href="<?php echo $page_content['button_link'] ?>"><?php echo $page_content['button_text'] ?></a>
                </form>
            </div>
        </div>
        <?php

        if (isset($page_content['ajax_rename'])) {
            ?>
            <script>
                fetch('processes/rename_upgrade.php', {
                    method: 'POST'
                })
                    .then(response => response.text())
                    .then(data => {
                        console.log(data);
                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
            </script>
            <?php
        }
    } ?>

</body>

</html>