<?php

use WeDevs\PM_Pro\Core\Router\Router;

$router = Router::singleton();

$router->post( 'sprints', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@store' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] )
    ->sanitizer( 'WeDevs\PM_Pro\Modules\Sprint\Src\Sanitizers\Sprint_Sanitizer' );

$router->get( 'sprints/{id}', 'WeDevs\PM_Pro\Modules\Sprint\Src\Helper\Sprint@get_sprints' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->get( 'sprints/{sprint_id}/tasks/{task_id}/close-modal', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@after_close_task_modal' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->get( 'sprints/refresh', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@refresh' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->post( 'sprints/{sprint_id}/delete', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@delete' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->post( 'sprints/{sprint_id}/tasks/{task_id}/delete', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@task_remove_from_sprint' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->post( 'sprints/{sprint_id}/tasks/{task_id}/move', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@task_move' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->post( 'sprints/{sprint_id}/add-task', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@add_task' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->post( 'sprints/{sprint_id}/update', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@update' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] )
    ->sanitizer( 'WeDevs\PM_Pro\Modules\Sprint\Src\Sanitizers\Sprint_Sanitizer' );

$router->post( 'sprints/{sprint_id}/update-status', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@update_status' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->get( 'sprints/{sprint_id}/tasks', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@get_tasks' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->get( 'sprints', 'WeDevs\PM_Pro\Modules\Sprint\Src\Helper\Sprint@get_sprints' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );

$router->get( 'sprints/{sprint_id}/projects/{project_id}/project-task', 'WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller@has_project_task_in_sprint' )
    ->permission( ['WeDevs\PM\Core\Permissions\Authentic'] );
