<?php
namespace WeDevs\PM_Pro\Modules\Sprint\Src\Transformers;

use WeDevs\PM_Pro\Modules\Sprint\Src\Models\Sprint;
use League\Fractal\TransformerAbstract;
use WeDevs\PM\User\Transformers\User_Transformer;
use WeDevs\PM\Task\Transformers\Task_Transformer;
use WeDevs\PM\Comment\Transformers\Comment_Transformer;
use WeDevs\PM\File\Transformers\File_Transformer;
use WeDevs\PM\Milestone\Transformers\Milestone_Transformer;
use League\Fractal\Pagination\IlluminatePaginatorAdapter;
use WeDevs\PM\Common\Traits\Resource_Editors;
use WeDevs\PM\Task\Models\Task;
use Illuminate\Database\Capsule\Manager as DB;
use Illuminate\Pagination\Paginator;
use League\Fractal\Resource\Collection as Collection;


class Sprint_Transformer extends TransformerAbstract {

    use Resource_Editors;

    protected $defaultIncludes = [
        //'creator', 'updater', 'milestone'
    ];

    public function transform( Sprint $item ) {

        $data = [
            'id'          => (int) $item->id,
            'title'       => $item->title,
            'description' => wedevs_pm_filter_content_url( $item->description ),
            'order'       => (int) $item->order,
            'status'      => $item->status,
            'start_at'    => wedevs_pm_format_date( $item->start_at ),
            'due_date'    => wedevs_pm_format_date( $item->due_date ),
            'created_at'  => wedevs_pm_format_date( $item->created_at ),
            'creator'     => $this->get_creator( $item ),
        ];

        return apply_filters( 'wedevs_pm_task_list_transform', $data, $item );
    }

    public function get_creator( $item ) {
        if(empty($item->created_by)) {
            return [];
        }
        $user = get_user_by( 'id', $item->created_by );
        if ( ! $user ) {
            return [];
        }

        $data = [
            'id'                => (int) $user->ID,
            'username'          => $user->user_login,
            'nicename'          => $user->user_nicename,
            'email'             => $user->user_email,
            'profile_url'       => $user->user_url,
            'display_name'      => $user->display_name,
            'manage_capability' => (int) wedevs_pm_has_manage_capability($user->ID),
            'create_capability' => (int) wedevs_pm_has_project_create_capability($user->ID),
            'avatar_url'        => get_avatar_url( $user->user_email ),
        ];

        return $user;
    }
}
