<?php

namespace WeDevs\PM_Pro\Modules\Sprint\Src\Models;

use WeDevs\PM\Core\DB_Connection\Model as Eloquent;
use WeDevs\PM\Common\Traits\Model_Events;
use WeDevs\PM\Task\Models\Task;
use WeDevs\PM\Common\Models\Boardable;
use WeDevs\PM\Comment\Models\Comment;
use WeDevs\PM\File\Models\File;
use WeDevs\PM\User\Models\User;
use WeDevs\PM\Milestone\Models\Milestone;
use WeDevs\PM\Common\Models\Meta;
use WeDevs\PM\Common\Traits\Board_Status;

class Sprint extends Eloquent {
    use Model_Events;

    protected $table = 'pm_sprints';

    protected $fillable = [
        'title',
        'description',
        'order',
        'status',
        'start_at',
        'due_date',
        'created_by',
        'updated_by',
    ];

    public function board() {
        return $this->hasMany( 'WeDevs\PM\Common\Models\Boardable', 'boardable_id' )->where( 'boardable_type', 'sprint' );
    }

    public function boardables() {
        return $this->hasMany( 'WeDevs\PM\Common\Models\Boardable', 'board_id' )->where( 'board_type', 'sprint' );
    }

    public function tasks( $project_id = false ) {
        $tasks = $this->belongsToMany( 'WeDevs\PM\Task\Models\Task', wedevs_pm_tb_prefix() . 'pm_boardables', 'board_id', 'boardable_id' )
            ->where( wedevs_pm_tb_prefix() . 'pm_boardables.boardable_type', 'task' )
            ->where( wedevs_pm_tb_prefix() . 'pm_boardables.board_type', 'sprint' )
            ->withPivot( 'order' );

        if ( $project_id ) {
            $tasks = apply_filters( 'wedevs_pm_filter_task_permission', $tasks,  $project_id );
        }

        return $tasks;
    }

    public function comments() {
        return $this->hasMany( 'WeDevs\PM\Comment\Models\Comment', 'commentable_id' )->where( 'commentable_type', 'sprint' );
    }



    public function metas() {
        return $this->hasMany( 'WeDevs\PM\Common\Models\Meta', 'entity_id' )
            ->where( 'entity_type', 'sprint' );
    }

    public static function latest_order() {
        return  self::max('order');
    }

}
