<?php
namespace WeDevs\PM_Pro\Modules\Sprint\Src\Controllers;

use WP_REST_Request;
use WeDevs\PM_Pro\Modules\Sprint\Src\Models\Sprint;
use WeDevs\PM\Task\Models\Task;
use League\Fractal;
use League\Fractal\Manager as Manager;
use League\Fractal\Serializer\DataArraySerializer;
use League\Fractal\Resource\Item as Item;
use League\Fractal\Resource\Collection as Collection;
use League\Fractal\Pagination\IlluminatePaginatorAdapter;
use WeDevs\PM\Common\Traits\Transformer_Manager;
use WeDevs\PM_Pro\Modules\Sprint\Src\Transformers\Sprint_Transformer;
use WeDevs\PM\Task\Transformers\Task_Transformer;
use WeDevs\PM\Common\Models\Boardable;
use WeDevs\PM\Common\Traits\Request_Filter;
use WeDevs\PM\Milestone\Models\Milestone;
use Illuminate\Pagination\Paginator;
use WeDevs\PM\Common\Models\Board;
use WeDevs\PM\Task\Controllers\Task_Controller as Task_Controller;
use WeDevs\PM_Pro\Modules\Sprint\Src\Helper\Sprint as Helper;
use WeDevs\PM_Pro\Modules\Sprint\Src\Models\Sprint_Projects;
use WeDevs\PM_Pro\Modules\Sprint\Src\Models\Sprint_Project_Tasks;
use WeDevs\PM\task\Helper\Task as Task_Helper;
use WeDevs\PM_Pro\Modules\Sub_Tasks\Src\Controllers\Sub_Tasks_Controller;
use WeDevs\PM\Project\Helper\Project;


class Sprint_Controller {

    use Transformer_Manager, Request_Filter;

    private static $_instance;

    public static function getInstance() {
        if ( !self::$_instance ) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function store( WP_REST_Request $request ) {
        $title       = $request->get_param( 'title' );
        $description = $request->get_param( 'description' );
        $start_at    = $request->get_param( 'start_at' );
        $due_date    = $request->get_param( 'due_date' );
        $projects    = $request->get_param( 'projects' );

        $is_valid = $this->is_validate( $request );

        if ( $is_valid !== true ) {
            wp_send_json_error( $is_valid['message'] );
        }

        $latest_order = Sprint::latest_order();
        $order        = $latest_order + 1;

        $sprint = Sprint::create( [
            'title'       => $title,
            'description' => $description,
            'order'       => $order,
            'start_at'    => date( 'Y-m-d', strtotime( $start_at ) ),
            'due_date'    => date( 'Y-m-d', strtotime( $due_date ) )
        ] );

        if ( $sprint ) {
            $this->udpate_projects( $projects, $sprint->id );
        }

        $sprint = Helper::get_results([
            'id'   => $sprint->id,
            'with' => 'projects'
        ]);

        wp_send_json_success( $sprint['data'] );
    }

    public function is_validate(  $request, $is_update = false ) {
        $title     = $request->get_param( 'title' );
        $projects  = $request->get_param( 'projects' );
        $due_date  = $request->get_param( 'due_date' );
        $sprint_id = $request->get_param( 'sprint_id' );

        if ( $is_update ) {
            $has_title = Sprint::where('id', '!=', $sprint_id)->where( 'title', $title )->get()->first();
        } else {
            $has_title = Sprint::where( 'title', $title )->get()->first();
        }

        if ( ! empty( $has_title ) ) {
            return [ 'message' => __( 'Sprint title unique!', 'pm-pro' ) ];
        }

        if ( empty( $projects ) ) {
            return [ 'message' => __( 'Sprint project required!', 'pm-pro' ) ];
        } else {
            $get_projects   = Project::get_results( [ 'id' => $projects ] );
            $db_project_ids = wp_list_pluck( $get_projects['data'], 'id' );
            $db_project_ids = array_filter( $db_project_ids );
            $projects       = array_filter($projects );

            $diff = array_diff( $projects, $db_project_ids );

            if ( ! empty( $diff ) ) {
                return [ 'message' => __( 'Sprint project required!', 'pm-pro' ) ];
            }
        }

        if ( empty( $due_date ) ) {
            return [ 'message' => __( 'Sprint date required!', 'pm-pro' ) ];
        }

        return true;
    }

    public function update_status( WP_REST_Request $request ) {
        $sprint_id   = $request->get_param( 'sprint_id' );
        $status   = $request->get_param( 'status' );

        $sprint = Sprint::find( $sprint_id );

        $sprint->update_model( [
            'status' => intval( $status )

        ] );

        wp_send_json_success();
    }

    public function update( WP_REST_Request $request ) {
        $sprint_id   = $request->get_param( 'sprint_id' );
        $title       = $request->get_param( 'title' );
        $description = $request->get_param( 'description' );
        $start_at    = $request->get_param( 'start_at' );
        $due_date    = $request->get_param( 'due_date' );
        $projects    = $request->get_param( 'projects' );

        $is_valid = $this->is_validate( $request, true );

        if ( $is_valid !== true ) {
            wp_send_json_success( $is_valid['message'] );
        }

        $sprint = Sprint::find( $sprint_id );

        $sprint->update_model( [
            'title'       => $title,
            'description' => $description,
            'start_at'    => date( 'Y-m-d', strtotime( $start_at ) ),
            'due_date'    => date( 'Y-m-d', strtotime( $due_date ) )

        ] );

        $this->udpate_projects( $projects, $sprint_id);

        $sprint = Helper::get_results([
            'id'   => $sprint->id,
            'with' => 'projects'
        ]);

        wp_send_json_success( $sprint['data'] );
    }

    public function udpate_projects( $project_ids, $sprint_id ) {
        $project_ids = ! is_array( $project_ids ) ? [intval( $project_ids )] : $project_ids;

        $sp_pro = Sprint_Projects::where( 'sprint_id', $sprint_id )
            ->get()
            ->toArray();

        $tb_pro_ids = wp_list_pluck( $sp_pro, 'project_id' );

        //delete
        foreach ( $tb_pro_ids as $tb_pro_id ) {
            if( ! in_array( $tb_pro_id, $project_ids ) ) {
                Sprint_Projects::where( 'sprint_id', $sprint_id )
                    ->where( 'project_id', $tb_pro_id )
                    ->delete();

                Sprint_Project_Tasks::where( 'sprint_id', $sprint_id )
                    ->where( 'project_id', $tb_pro_id )
                    ->delete();
            }
        }

        //insert
        foreach ( $project_ids as $project_id ) {
            if( ! in_array( $project_id, $tb_pro_ids ) ) {
                $this->add_project_in_sprint( $sprint_id, $project_id );
            }
        }
    }

    public function add_project_in_sprint( $sprint_id, $project_id ) {
        Sprint_Projects::create([
            'sprint_id'  => $sprint_id,
            'project_id' => $project_id
        ]);
    }

    public function delete( WP_REST_Request $request ) {
        // Grab user inputs
        $sprint_id = $request->get_param( 'sprint_id' );

        // Select the task list to be deleted
        Sprint::where( 'id', $sprint_id )->delete();
        Sprint_Projects::where( 'sprint_id', $sprint_id )->delete();
        Sprint_Project_Tasks::where( 'sprint_id', $sprint_id )->delete();

        wp_send_json_success();
    }

    public function task_remove_from_sprint( WP_REST_Request $request ) {
        // Grab user inputs
        $sprint_id = $request->get_param( 'sprint_id' );
        $task_id = $request->get_param( 'task_id' );

        // Select the task list to be deleted
        Sprint_Project_Tasks::where( 'sprint_id', $sprint_id )
            ->where('task_id', $task_id)
            ->delete();

        wp_send_json_success([
            'sprint_id' => $sprint_id,
            'task_id' => $task_id
        ]);
    }

    public function add_task( WP_REST_Request $request ) {

        $sprint_id  = $request->get_param( 'sprint_id' );
        $task_id    = $request->get_param( 'task_id' );
        $project_id = $request->get_param( 'project_id' );
        $list_id    = $request->get_param( 'list_id' );

        //Make task id to array because for importing multiple task.
        $task_id    = is_array( $task_id ) ? $task_id : [$task_id];

        $has_project = Sprint_Projects::where( 'sprint_id', $sprint_id )
            ->where( 'project_id', $project_id )
            ->first();

        if( empty( $has_project ) ) {
            wp_send_json_error( [
                'error' => true,
                'message' => __( 'This sprint contain no project!', 'pm-pro' )
            ] );
            //$this->add_project_in_sprint( $sprint_id, $project_id );
        }

        $sprint_sroject_task = Sprint_Project_Tasks::where( 'sprint_id', $sprint_id )
            ->whereIn( 'task_id', $task_id )
            ->get()
            ->toArray();

        $db_task_ids       = wp_list_pluck( $sprint_sroject_task, 'task_id' );
        $inserted_task_ids = array_diff( $task_id, $db_task_ids );

       // pmpr($db_task_ids, $task_id, $inserted_task_ids, $project_id, $sprint_id, $list_id);  die();

        foreach ( $inserted_task_ids as $key => $id ) {
            Sprint_Project_Tasks::create([
                'sprint_id'  => $sprint_id,
                'project_id' => $project_id,
                'task_id'    => $id,
                'list_id'    => $list_id
            ]);
        }

        $sprint = Helper::get_results([
            'id'   => $sprint_id,
            'with' => 'projects, incomplete_tasks, complete_tasks'
        ]);

        if ( empty( $inserted_task_ids ) ) {
            $task = [ 'data' => [] ];
        } else {
            $task = Task_Helper::get_results([
                'id' => $inserted_task_ids,
                'with' => 'assignees'
            ]);
        }

        wp_send_json_success([
            'sprint' => $sprint,
            'task'   => $task
        ]);
    }

    public function get_tasks( WP_REST_Request $request ) {
        $sprint_id = $request->get_param( 'sprint_id' );
        $with      = $request->get_param( 'with' );
        $per_page  = $request->get_param( 'task_per_page' );
        $page      = $request->get_param( 'task_page' );


        $incomplete_task_per_page = $request->get_param( 'incomplete_task_per_page' );
        $incomplete_task_pages    = $request->get_param( 'incomplete_task_pages' );
        $complete_task_per_page   = $request->get_param( 'complete_task_per_page' );
        $complete_task_pages      = $request->get_param( 'complete_task_pages' );

        $sprint = Helper::get_results([
            'success' => true,
            'id'   => $sprint_id,
            'with' => $with
        ]);

        wp_send_json_success( $sprint['data'] );

    }

    public static function after_delete_project( $project_id ) {

        Sprint_Projects::where( 'project_id', $project_id )
            ->delete();

        Sprint_Project_Tasks::where( 'project_id', $project_id )
            ->delete();
    }

    public static function after_delete_task_list( $list_id ) {

        Sprint_Project_Tasks::where( 'list_id', $list_id )
            ->delete();
    }

    public static function after_delete_task( $task_id ) {

        Sprint_Project_Tasks::where( 'task_id', $task_id )
            ->delete();
    }

    public function task_move( WP_REST_Request $request ) {

        $from_sprint_id = $request->get_param( 'sprint_id' );
        $to_sprint_id   = $request->get_param( 'to_sprint_id' );

        $sprint = Helper::get_results( [ 'id' => $to_sprint_id, 'with' => 'projects' ] );
        $to_sprint_projects = wp_list_pluck( $sprint['data']['projects']['data'], 'project_id' );

        $task_id      = $request->get_param( 'task_id' );
        $task         = wedevs_pm_get_tasks( [ 'id' => $task_id ] );
        $t_project_id = $task['data']['project_id'];

        if ( ! in_array( $t_project_id, $to_sprint_projects ) ) {
            wp_send_json_error( [ 'message' => __( 'Task projects does not exist in ' . $sprint['data']['title'] . ' sprint' ) ] );
            exit();
        }

        $db_sprint_task = Sprint_Project_Tasks::where( 'task_id', $task_id )
            ->where( 'sprint_id', $from_sprint_id )
            ->get()
            ->first();

        if ( empty( $db_sprint_task ) ) {
            wp_send_json_error();
        }

        $project_id = $db_sprint_task->project_id;
        $list_id = $db_sprint_task->list_id;

        Sprint_Project_Tasks::where( 'task_id', $task_id )
            ->where( 'sprint_id', $from_sprint_id )
            ->delete();

        Sprint_Project_Tasks::create([
            'sprint_id'  => $to_sprint_id,
            'project_id' => $project_id,
            'task_id'    => $task_id,
            'list_id'    => $list_id
        ]);

        $from_sprint = Helper::get_results([
            'id' => $from_sprint_id,
            'with' => 'projects, incomplete_tasks, complete_tasks'
        ]);

        $to_sprint = Helper::get_results([
            'id' => $to_sprint_id,
            'with' => 'projects, incomplete_tasks, complete_tasks'
        ]);

        wp_send_json_success([
            'fromSprint' => $from_sprint,
            'toSprint'   => $to_sprint
        ]);
    }

    public function after_close_task_modal( WP_REST_Request $request ) {
        $sprint_id = $request->get_param( 'sprint_id' );
        $task_id   = $request->get_param( 'task_id' );

        $task = Task_Helper::get_results([
            'id' => $task_id,
            'with' => 'assignees'
        ]);

        $subtasks = ( new \WeDevs\PM_Pro\Modules\Sub_Tasks\Src\Controllers\Sub_Tasks_Controller() )->get_sub_tasks([
            'task_id' => $task_id,
        ]);

        $sprint = Helper::get_results([
            'id' => $sprint_id
        ]);

        wp_send_json_success([
            'sprint'   => $sprint,
            'task'     => $task,
            'subTasks' => $subtasks
        ]);
    }

    public function refresh( WP_REST_Request $request ) {
        global $wpdb;

        $sprint_id   = $request->get_param( 'sprint_id' );
        $task_id     = $request->get_param( 'task_id' );
        $sub_task_id = $request->get_param( 'sub_task_id' );
        $sprint      = false;
        $task        = false;
        $subtask     = false;

        if ( ! empty( $sprint_id ) ) {
            $sprint = Helper::get_results([
                'id' => $sprint_id
            ]);
        }


        if ( ! empty( $task_id ) ) {
            $tb_tasks = wedevs_pm_tb_prefix() . 'pm_tasks';

            $task = Task_Helper::get_results([
                'id' => $task_id,
                'with' => ['assignees']
            ]);

            if ( wedevs_pm_get_estimation_type() == 'subtask' ) {

                $query ="SELECT sum(estimation) as estimation
                    FROM $tb_tasks
                    WHERE parent_id = $task_id
                    GROUP BY parent_id";

                $estimation = $wpdb->get_var( $query );

                $task['data']['estimation'] = empty( $estimation ) ? 0 : $estimation*60;
            }
        }

        if ( ! empty( $sub_task_id ) ) {
            $subtask = ( new \WeDevs\PM_Pro\Modules\Sub_Tasks\Src\Controllers\Sub_Tasks_Controller() )->get_sub_task( $sub_task_id );
        }

        wp_send_json_success([
            'sprint'  => $sprint,
            'task'    => $task,
            'subtask' => $subtask
        ]);

    }

    public function has_project_task_in_sprint( WP_REST_Request $request ) {
        $sprint_id   = $request->get_param( 'sprint_id' );
        $project_id  = $request->get_param( 'project_id' );

        global $wpdb;

        $tb_spt = wedevs_pm_tb_prefix() . 'pm_sprint_project_tasks';

        $query = $wpdb->prepare("
            SELECT count(task_id)
            FROM $tb_spt
            WHERE project_id=%d AND sprint_id=%d",
            $project_id, $sprint_id
        );

        $has_task = $wpdb->get_var( $query );

        wp_send_json_success([
            'has_task' => $has_task > 0 ? true : false
        ]);
    }
}



