<?php
/**
 * Module Name: Sprint
 * Description: Generate invoice for your projects anytime; print, download and send emails to your client.
 * Module URI: https://wedevs.com/weforms/
 * Thumbnail URL: /views/assets/images/sub-task.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */


if ( ! class_exists( 'sprint' ) ) :
    final class sprint {

        /**
         * This plugin's instance.
         *
         * @var sprint
         * @since 1.0.0
         */
        private static $instance;

        /**
         * Main sprint Instance.
         *
         * Insures that only one instance of sprint exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 1.0.0
         * @static
         * @return object|sprint The one true sprint
         */
        public static function instance() {
            if ( ! isset( self::$instance ) && ! ( self::$instance instanceof sprint ) ) {
                self::$instance = new self();
                self::$instance->define_constants();
                self::$instance->includes();
                self::$instance->dependency_class_instance();
            }
            return self::$instance;
        }

        /**
         * Load actions
         *
         * @return void
         */
        private function includes() {
            //include( sprint_PATH . '/helpers/functions.php' );
        }

        /**
         * Define woogool Constants
         *
         * @return type
         */
        private function define_constants() {
            $this->define( 'PM_PRO_SPRINT_PATH', dirname( __FILE__ ) );
            $this->define( 'PM_PRO_SPRINT_VIEW_PATH', dirname( __FILE__ ) . '/views' );
            $this->define( 'PM_PRO_SPRINT_VIEW_URL', plugin_dir_url( __FILE__ ) . '/views' );
        }

        /**
         * Define constant if not already set
         *
         * @param  string $name
         * @param  string|bool $value
         * @return type
         */
        private function define( $name, $value ) {
            if ( ! defined( $name ) ) {
                define( $name, $value );
            }
        }

        private function dependency_class_instance() {
            \WeDevs\PM_Pro\Modules\Sprint\Core\Scripts::instance();
            \WeDevs\PM_Pro\Modules\Sprint\Core\Actions::instance();
            \WeDevs\PM_Pro\Modules\Sprint\Core\Filters::instance();
        }

    }

endif;


/**
 * The main function for that returns sprint
 *
 */
function wedevs_pm_pro_sprint() {
    return sprint::instance();
}

wedevs_pm_pro_sprint();





