<?php
namespace WeDevs\PM_Pro\Modules\Sprint\Core;

use WeDevs\PM_Pro\Modules\Sprint\Src\Controllers\Sprint_Controller;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Load general WP action hook
 */
class Actions {
    /**
     * This plugin's instance.
     *
     * @var CoBlocks_Accordion_IE_Support
     */
    private static $instance;

    /**
     * Registers the plugin.
     */
    public static function instance() {
         if ( !self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * The Constructor.
     */
    public function __construct() {
        add_action('pm-activation-sprint', [ $this, 'install' ] );
        add_action( 'wedevs_pm_menu_before_load_scripts', [ $this, 'admin_menu' ] );
        add_action( 'wedevs_pm_after_delete_project', [ $this, 'after_delete_project' ] );
        add_action( 'wedevs_pm_after_delete_task_list', [ $this, 'after_delete_task_list' ] );
        add_action( 'wedevs_pm_after_delete_task', [ $this, 'after_delete_task' ] );
    }

    function install() {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        global $wpdb;
        $table_name = $wpdb->prefix . 'pm_sprints';

        $sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
              `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
              `title` varchar(255) NOT NULL,
              `description` text,
              `order` int(11) UNSIGNED DEFAULT NULL,
              `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
              `start_at` timestamp NULL DEFAULT NULL,
              `due_date` timestamp NULL DEFAULT NULL,
              `created_by` int(11) UNSIGNED DEFAULT NULL,
              `updated_by` int(11) UNSIGNED DEFAULT NULL,
              `created_at` timestamp NULL DEFAULT NULL,
              `updated_at` timestamp NULL DEFAULT NULL,
              UNIQUE KEY unique_title (title),
              PRIMARY KEY (`id`)
            ) DEFAULT CHARSET=utf8";

        dbDelta($sql);

        $table_name = $wpdb->prefix . 'pm_sprint_projects';

        $sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
             `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
              `sprint_id` int(11) UNSIGNED DEFAULT NULL,
              `project_id` int(11) UNSIGNED DEFAULT NULL,
              PRIMARY KEY (`id`),
              KEY `sprint_id` (`sprint_id`),
              KEY `project_id` (`project_id`)
            ) DEFAULT CHARSET=utf8";

        dbDelta($sql);

        $table_name = $wpdb->prefix . 'pm_sprint_project_tasks';

        $sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
              `sprint_id` int(11) UNSIGNED DEFAULT NULL,
              `project_id` int(11) UNSIGNED DEFAULT NULL,
              `task_id` int(11) UNSIGNED DEFAULT NULL,
              `list_id` int(11) UNSIGNED DEFAULT NULL,
              KEY `sprint_id` (`sprint_id`),
              KEY `project_id` (`project_id`)
            ) DEFAULT CHARSET=utf8";

        dbDelta($sql);

    }

    function admin_menu( $home ) {
        global $submenu;
        $has_manage_capability = wedevs_pm_has_manage_capability();

        //if ( $has_manage_capability ) {
            $submenu['pm_projects'][] = [ __( 'Sprint', 'pm' ), 'read', 'admin.php?page=pm_projects#/sprints' ];
        //}

        add_action( 'admin_print_styles-' . $home, array( 'WeDevs\\PM_Pro\\Modules\\Sprint\\Core\\Scripts', 'load_scripts' ) );
    }

    function after_delete_project( $project ) {
        Sprint_Controller::after_delete_project( $project->id );
    }

    function after_delete_task_list( $list ) {
        Sprint_Controller::after_delete_task_list( $list->id );
    }

    function after_delete_task( $task_id ) {
        Sprint_Controller::after_delete_task( $task_id );
    }
}
