<?php

namespace WeDevs\PM_Pro\Core\WP;

class Register_Scripts {

	public static function scripts() {
		$scripts = wedevs_pm_pro_config('scripts');

		foreach ( $scripts as $script ) {
			$path = empty( $script['path'] ) ? wedevs_pm_pro_config( 'app.version' ) : filemtime( $script['path'] );

			wp_register_script(
				$script['id'],
				$script['url'],
				$script['dependency'],
				$path,
				$script['in_footer']
			);
		}
	}

	public static function styles() {
		$styles = wedevs_pm_pro_config('style');

		foreach ( $styles as $style ) {

			$path = empty( $style['path'] ) ? wedevs_pm_pro_config( 'app.version' ) : filemtime( $style['path'] );
			wp_register_style(
				$style['id'],
				$style['url'],
				$style['dependency'],
				$path,
				'all'
			);
		}
	}
}
