<?php

namespace WeDevs\PM_Pro\Core\WP;

class Enqueue_Scripts {

    public static function scripts() {
        $scripts_id = [
            'pm-pro-scripts'
        ];

        wp_enqueue_media();

        foreach ( $scripts_id as $script_id ) {
            do_action( 'wedevs_before_loaded_' . $script_id );

            wp_enqueue_script( $script_id );

            do_action( 'wedevs_after_loaded_' . $script_id );
        }

        wp_localize_script( 'pm-config', 'PM_Pro_Vars', self::localize_data() );
    }

    public static function styles() {
        $styles_id = [
            'pm-pro-style',
        ];

        foreach ( $styles_id as $style ) {
            do_action( 'wedevs_before_loaded_' . $style );

            wp_enqueue_style( $style );

            do_action( 'wedevs_after_loaded_' . $style );
        }
    }

    public static function localize_data() {
        return [
            'ajaxurl'            => admin_url( 'admin-ajax.php' ),
            'nonce'              => wp_create_nonce( 'pm_pro_nonce' ),
            'base_url'           => home_url(),
            'api_base_url'       => esc_url_raw( get_rest_url() ),
            'api_namespace'      => wedevs_pm_api_namespace(),
            'permalinkStructure' => get_option( 'permalink_structure' ),
            'dir_url'            => wedevs_pm_pro_config('define.url'),
            'module_path'        => wedevs_pm_pro_config('define.module_path'),
            'base_path'          => wedevs_pm_pro_config('define.path'),
            'manage_capability'  => wedevs_pm_get_setting( 'managing_capability' ),
            'pm_logo'            => wedevs_pm_pro_get_logo(),
            'locale'             => wedevs_pm_pro_get_locale(),
            'wperp'              => class_exists('WeDevs_ERP'),
            'active_modules'     => wedevs_pm_pro_get_active_modules(),
            'pages'              => get_pages(),
            'page'               => get_option( 'pm_pages' ),
            // 'progress_page_slug' => pm_pro_progress_page_slug(),
            // 'reports_page_slug'  => pm_pro_reports_page_slug(),
            // 'modules_page_slug'  => pm_pro_modules_page_slug()
        ];
    }
}
