<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace BuddyBossPlatform\Doctrine\Common\Cache\Psr6;

use BuddyBossPlatform\Doctrine\Common\Cache\Cache;
use BuddyBossPlatform\Doctrine\Common\Cache\CacheProvider;
use BuddyBossPlatform\Psr\Cache\CacheItemPoolInterface;
use BuddyBossPlatform\Symfony\Component\Cache\Adapter\DoctrineAdapter as SymfonyDoctrineAdapter;
use BuddyBossPlatform\Symfony\Contracts\Service\ResetInterface;
use function rawurlencode;
/**
 * This class was copied from the Symfony Framework, see the original copyright
 * notice above. The code is distributed subject to the license terms in
 * https://github.com/symfony/symfony/blob/ff0cf61278982539c49e467db9ab13cbd342f76d/LICENSE
 */
final class DoctrineProvider extends CacheProvider
{
    /** @var CacheItemPoolInterface */
    private $pool;
    public static function wrap(CacheItemPoolInterface $pool) : Cache
    {
        if ($pool instanceof CacheAdapter) {
            return $pool->getCache();
        }
        if ($pool instanceof SymfonyDoctrineAdapter) {
            $getCache = function () {
                // phpcs:ignore Squiz.Scope.StaticThisUsage.Found
                return $this->provider;
            };
            return $getCache->bindTo($pool, SymfonyDoctrineAdapter::class)();
        }
        return new self($pool);
    }
    private function __construct(CacheItemPoolInterface $pool)
    {
        $this->pool = $pool;
    }
    /** @internal */
    public function getPool() : CacheItemPoolInterface
    {
        return $this->pool;
    }
    public function reset() : void
    {
        if ($this->pool instanceof ResetInterface) {
            $this->pool->reset();
        }
        $this->setNamespace($this->getNamespace());
    }
    /**
     * {@inheritdoc}
     */
    protected function doFetch($id)
    {
        $item = $this->pool->getItem(rawurlencode($id));
        return $item->isHit() ? $item->get() : \false;
    }
    /**
     * {@inheritdoc}
     *
     * @return bool
     */
    protected function doContains($id)
    {
        return $this->pool->hasItem(rawurlencode($id));
    }
    /**
     * {@inheritdoc}
     *
     * @return bool
     */
    protected function doSave($id, $data, $lifeTime = 0)
    {
        $item = $this->pool->getItem(rawurlencode($id));
        if (0 < $lifeTime) {
            $item->expiresAfter($lifeTime);
        }
        return $this->pool->save($item->set($data));
    }
    /**
     * {@inheritdoc}
     *
     * @return bool
     */
    protected function doDelete($id)
    {
        return $this->pool->deleteItem(rawurlencode($id));
    }
    /**
     * {@inheritdoc}
     *
     * @return bool
     */
    protected function doFlush()
    {
        return $this->pool->clear();
    }
    /**
     * {@inheritdoc}
     *
     * @return array|null
     */
    protected function doGetStats()
    {
        return null;
    }
}
